window.onload = function() {
    async function fetchLogs() {
        try {
            console.log("Fetching logs...");

            const response = await fetch("http://127.0.0.1:5000/api/logs");
            console.log("HTTP Status:", response.status);

            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }

            const data = await response.json();
            console.log("Raw Response:", data);

            // Ensure logsContainer exists
            const logsContainer = document.getElementById("logsContainer");
            if (!logsContainer) {
                console.error("Error: logsContainer element not found!");
                return;  // Stop execution if the element is missing
            }

            logsContainer.innerHTML = "";  // Clear old logs before adding new ones

            data.logs.forEach(log => {
                logsContainer.innerHTML += `
                    <div class="log-entry">
                        <p><strong>Timestamp:</strong> ${log.timestamp}</p>
                        <p><strong>Status:</strong> ${log.status}</p>
                        <p><strong>Details:</strong> ${log.details}</p>
                        <hr>
                    </div>
                `;
            });

        } catch (error) {
            console.error("Error fetching logs:", error);
        }
    }

    // Fetch logs every 5 seconds
    setInterval(fetchLogs, 5000);
    
    // Initial fetch
    fetchLogs();
};
