import sys
import os
from flask import Flask, jsonify
from flask_cors import CORS
from routes.detect import detect_bp  # Import intrusion detection API
from flask import Flask
from routes.detect import detect_bp
from routes.logs import logs_bp  # ✅ Import logs API

app = Flask(__name__)

# ✅ Register Blueprints
app.register_blueprint(detect_bp)
app.register_blueprint(logs_bp)  # ✅ Register logs API

if __name__ == "__main__":
    app.run(debug=True)

# Ensure the backend directory is recognized as a module
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), "..")))

app = Flask(__name__)
CORS(app)  # Enable CORS for cross-origin requests

# Register the Blueprint for intrusion detection API
app.register_blueprint(detect_bp, url_prefix="/api")

@app.route("/", methods=["GET"])
def home():
    return jsonify({"message": "Intrusion Detection System API is running!"})

if __name__ == "__main__":
    app.run(debug=True, host="0.0.0.0", port=5000)
