import os
import joblib
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.ensemble import RandomForestClassifier
from sklearn.metrics import accuracy_score, classification_report

# Sample dataset (replace with real dataset)
data = {
    "contains_suspicious_words": [1, 0, 1, 0, 1, 0, 0, 1, 1, 0],
    "has_https": [1, 1, 0, 0, 1, 1, 0, 1, 0, 1],
    "is_shortened": [0, 1, 0, 1, 1, 0, 1, 0, 1, 0],
    "keystroke_pattern": [0, 1, 0, 1, 0, 0, 1, 0, 1, 1],
    "mouse_movement_anomaly": [0, 0, 1, 1, 0, 1, 1, 0, 0, 1],
    "label": [1, 0, 1, 0, 1, 0, 0, 1, 1, 0]
}

df = pd.DataFrame(data)

# Split into training and test sets
X = df.drop("label", axis=1)
y = df["label"]
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)

# Train a model
model = RandomForestClassifier(n_estimators=100, random_state=42)
model.fit(X_train, y_train)

# Evaluate the model
y_pred = model.predict(X_test)
accuracy = accuracy_score(y_test, y_pred)
print(f"✅ Model Accuracy: {accuracy:.2f}")
print("✅ Classification Report:\n", classification_report(y_test, y_pred))

# Save the model
model_path = os.path.join(os.path.dirname(__file__), "models", "anomaly_detector.pkl")
joblib.dump(model, model_path)
print(f"✅ Model saved at: {model_path}")
