from flask_sqlalchemy import SQLAlchemy
from datetime import datetime

# Initialize SQLAlchemy

db = SQLAlchemy()

# Define the Logs table
class Log(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    url = db.Column(db.String(255), nullable=False)
    prediction = db.Column(db.String(50), nullable=False)
    timestamp = db.Column(db.DateTime, default=datetime.utcnow)

    def __init__(self, url, prediction):
        self.url = url
        self.prediction = prediction

    def to_dict(self):
        return {
            "id": self.id,
            "url": self.url,
            "prediction": self.prediction,
            "timestamp": self.timestamp.strftime("%Y-%m-%d %H:%M:%S")
        }

# Define the Users table (optional, if needed in the future)
class User(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(80), unique=True, nullable=False)
    password_hash = db.Column(db.String(255), nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)

    def __init__(self, username, password_hash):
        self.username = username
        self.password_hash = password_hash
