import os
import json
from flask import Blueprint, jsonify

logs_bp = Blueprint("logs", __name__)

LOG_FILE = os.path.abspath(os.path.join("logs", "intrusion_logs.json"))

@logs_bp.route("/api/logs", methods=["GET"])
def get_logs():
    """Fetch intrusion detection logs."""
    if not os.path.exists(LOG_FILE):
        return jsonify({"logs": [], "message": "No logs found."}), 200

    with open(LOG_FILE, "r") as f:
        logs = json.load(f)

    return jsonify({"logs": logs})
