chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
    if (changeInfo.status === "complete" && tab.url) {
        analyzeTab(tab);
    }
});

async function analyzeTab(tab) {
    let url = tab.url;

    if (url.startsWith("chrome://")) return;

    let features = extractFeatures(url);

    try {
        let response = await fetch("http://127.0.0.1:5000/api/detect", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(features),
        });

        let result = await response.json();
        console.log("🔍 Background Detection Result:", result);

        if (result.prediction === 1) {
            chrome.notifications.create({
                type: "basic",
                iconUrl: "icon.png",
                title: "⚠️ Suspicious Website Detected!",
                message: "This website may be malicious. Proceed with caution.",
            });
        }
    } catch (error) {
        console.error("Error in background detection:", error);
    }
}

function extractFeatures(url) {
    return {
        "url_length": url.length,
        "has_https": url.startsWith("https") ? 1 : 0,
        "num_dots": (url.match(/\./g) || []).length,
        "is_shortened": /bit\.ly|goo\.gl|t\.co|tinyurl\.com/.test(url) ? 1 : 0,
        "contains_suspicious_words": /free|win|prize|bonus|claim/.test(url) ? 1 : 0,
        "mouse_movement_anomaly": 0, // Placeholder
        "keystroke_pattern": 0 // Placeholder
    };
}
